/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSmallOre
extends ItemTFC
implements IMetalItem {
    private static final Map<Ore, ItemSmallOre> MAP = new HashMap<Ore, ItemSmallOre>();
    private final Ore ore;

    public static ItemSmallOre get(Ore ore) {
        return MAP.get((Object)ore);
    }

    public static ItemStack get(Ore ore, int amount) {
        return new ItemStack((Item)MAP.get((Object)ore), amount);
    }

    public ItemSmallOre(Ore ore) {
        this.ore = ore;
        if (MAP.put(ore, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_77656_e(0);
        if (ore.getMetal() != null) {
            String name = ore.getMetal().getRegistryName().func_110623_a();
            OreDictionaryHelper.register(this, "ore", name, "small");
            OreDictionaryHelper.register(this, "ore", "small", name);
            if (ore.getMetal() == Metal.WROUGHT_IRON && ConfigTFC.General.MISC.dictionaryIron) {
                OreDictionaryHelper.register(this, "ore", "iron", "small");
                OreDictionaryHelper.register(this, "ore", "small", "iron");
            }
        } else {
            String name = ore.getMetal().getRegistryName().func_110623_a();
            OreDictionaryHelper.register(this, "ore", name, "small");
            OreDictionaryHelper.register(this, "ore", "small", name);
        }
    }

    @Override
    public Metal getMetal(ItemStack stack) {
        return this.ore.getMetal();
    }

    @Override
    public int getSmeltAmount(ItemStack stack) {
        return ConfigTFC.General.MISC.smallOreMetalAmount;
    }

    @Override
    public boolean canMelt(ItemStack stack) {
        return this.ore.canMelt();
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Nonnull
    public Ore getOre() {
        return this.ore;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        Metal metal = this.getMetal(stack);
        if (metal != null) {
            int smeltAmount = this.getSmeltAmount(stack);
            switch (ConfigTFC.Client.TOOLTIP.oreTooltipMode) {
                case HIDE: {
                    break;
                }
                case UNIT_ONLY: {
                    String info = String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{smeltAmount}));
                    tooltip.add(info);
                    break;
                }
                case TOTAL_ONLY: {
                    String stackTotal = String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units.total", (Object[])new Object[]{smeltAmount * stack.func_190916_E()}));
                    tooltip.add(stackTotal);
                    break;
                }
                case ALL_INFO: {
                    String infoTotal = stack.func_190916_E() > 1 ? String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units.info_total", (Object[])new Object[]{smeltAmount, smeltAmount * stack.func_190916_E()})) : String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{smeltAmount}));
                    tooltip.add(infoTotal);
                    break;
                }
                case ADVANCED: {
                    String advancedTotal = stack.func_190916_E() > 1 ? String.format("%s: %s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units.info_total", (Object[])new Object[]{smeltAmount, smeltAmount * stack.func_190916_E()}), I18n.func_135052_a((String)"tfc.tooltip.melttemp", (Object[])new Object[]{(int)metal.getMeltTemp()})) : String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{smeltAmount}));
                    tooltip.add(advancedTotal);
                }
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this.ore.getMetal() != null ? new ItemHeatHandler(nbt, this.ore.getMetal().getSpecificHeat(), this.ore.getMetal().getMeltTemp()) : null;
    }
}

